function n_int = fault_slip_int_point(Delta_y_int,flag_merged,n_max,n_min,y_a,y_bound_0)
%
% Computes the distribution of the number of integration points over segments below and
% above the singular point y_a = -a or y_a = a (in case of isolated slip patches); or below,
% in-between and above the singular points y_a(1) = -a and y_a(2) = a (in case of merged slip
% patches).      
%

y_minus = y_bound_0(1);
y_plus = y_bound_0(2);

if flag_merged == 0 % slip patches have not yet merged
    % Compute number of integration points below and above singular point y = y_a:
    n_max_half = round(n_max/2); % maximum allowed number of integration points per slip patch
    n_min_half = round(n_min/2); % minimum required number of integration points per slip patch
    n_min_minus = max(5,round(n_min_half * (y_a-y_minus)/(y_plus-y_minus) )); % ...
        % minimum required number of integration points between y_minus and y_a
    n_min_plus = max(5,n_min - n_min_minus); % minimum required number of integration ...
        % points between y_a and y_plus
    n_minus_1 = max(n_min_minus,round((y_a-y_minus)/Delta_y_int)); % number of integration ...
        % points between y_minus and y_a
    n_plus_1 = max(n_min_plus,round((y_plus-y_a)/Delta_y_int)); % number of integration ...
        % points between y_a and y_plus
    n_minus_2 = 0; % dummy
    n_mid = 0; % dummy
    n_plus_2 = 0; % dummy
    n_tot = n_minus_1 + n_plus_1; % number of integration points between y_minus and y_plus
    if n_tot > n_max_half
        n_minus_1 = round(n_minus_1 * n_max_half/n_tot);
        n_plus_1 = round(n_plus_1 * n_max_half/n_tot);
        n_tot = n_minus_1 + n_plus_1;
    end
else % slip patches have merged
    % Compute number of integration points below, above and in-between singular points ...
        % y = -a and y = a:
    n_min_minus = max(5,round(n_min * (y_a(1)-y_minus)/(y_plus-y_minus) )); % ...
        % minimum required number of integration points between y_minus and -a
    n_min_mid = max(5,round(n_min * (y_a(2)-y_a(1))/(y_plus-y_minus) )); % ...
        % minimum required number of integration points between -a and a 
    n_min_plus = max(5,n_min - n_min_minus - n_min_mid); % minimum required number of ...
        % integration points between a and y_plus
    n_minus_2 = max(n_min_minus,round((y_a(1)-y_minus)/Delta_y_int)); % number of ...
        % integration points between y_minus and -a
    n_mid = max(n_min_mid,round((y_a(2)-y_a(1))/Delta_y_int)); % number of integration ...
        % points between -a and a
    n_plus_2 = max(n_min_plus,round((y_plus-y_a(2))/Delta_y_int)); % number of integration ...
        % points between a and y_plus
    n_minus_1 = 0; % dummy
    n_plus_1 = 0; % dummy
    n_tot = n_minus_2 + n_mid + n_plus_2; % number of integration points between y_minus ...
        % and y_plus
    if n_tot > n_max
        n_minus_2 = round(n_minus_2 * n_max/n_tot);
        n_mid = round(n_mid * n_max/n_tot);
        n_plus_2 = round(n_plus_2 * n_max/n_tot);
        n_tot = n_minus_2 + n_mid + n_plus_2;
    end
end
n_int = [n_mid,n_minus_1,n_minus_2,n_plus_1,n_plus_2,n_tot];
    % n_mid     = number of integration points between -a and a (merged case)
    % n_minus_1 = number of integration points between y_minus and y_a (unmerged case)
    % n_minus_2 = number of integration points between y_minus and -a (merged case)
    % n_plus_1  = number of integration points between y_a and y_plus (unmerged case)
    % n_plus_2  = number of integration points between a and y_plus (merged case)
    % n_tot     = number of integration points between y_minus and y_plus (merged or unmerged)
    